/****** Object:  StoredProcedure [dbo].[P_GERA_EST_PROD_CPL_ROBO_TRANSF]    Script Date: 15/06/2022 18:34:05 ******/
IF  EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_EST_PROD_CPL_ROBO_TRANSF]') AND type in (N'P', N'PC'))
DROP PROCEDURE P_GERA_EST_PROD_CPL_ROBO_TRANSF
GO

CREATE PROCEDURE P_GERA_EST_PROD_CPL_ROBO_TRANSF
AS BEGIN

DECLARE @CD_EST_PROD_CPL_ROBO INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PROD INT
DECLARE @TP_PRECO INT
DECLARE @CD_MOV_OP INT
DECLARE @CD_PED INT

DECLARE @XML XML

DECLARE @CD_LOTE INT
DECLARE @NR_LOTE VARCHAR(100)
DECLARE @DT_FABRIC DATE
DECLARE @DT_VALID DATE


SELECT @CD_MOV_OP = CD_MOV_OP, @TP_PRECO = TP_PRECO FROM GLB_MOV_OP WHERE TP_MOV = 10 AND TP_MOV_OP_TRANSA = 1

SET @TP_PRECO = 3;

DECLARE 
	CURSOR_TRANSF
CURSOR FOR
SELECT 
	EST_PROD_CPL_ROBO.CD_EST_PROD_CPL_ROBO,
	EST_PROD_CPL_ROBO.CD_PROD,
	CONVERT(INT, CASE WHEN ISNUMERIC(PRC_FILIAL_CONFIG.VALOR) = 1 THEN PRC_FILIAL_CONFIG.VALOR ELSE -1 END) AS CD_FILIAL
FROM 
	EST_PROD_CPL_ROBO_PEND_TRANSF
	INNER JOIN EST_PROD_CPL_ROBO ON
		EST_PROD_CPL_ROBO_PEND_TRANSF.CD_EST_PROD_CPL_ROBO = EST_PROD_CPL_ROBO.CD_EST_PROD_CPL_ROBO
	INNER JOIN PRC_FILIAL_CONFIG ON
		EST_PROD_CPL_ROBO.CD_EMP = PRC_FILIAL_CONFIG.CD_EMP
		AND EST_PROD_CPL_ROBO.CD_FILIAL = PRC_FILIAL_CONFIG.CD_FILIAL
		AND PRC_FILIAL_CONFIG.CD_CHAVE = 'CD_FILIAL_ORIGEM_ROBO'


OPEN CURSOR_TRANSF


FETCH NEXT FROM CURSOR_TRANSF INTO @CD_EST_PROD_CPL_ROBO, @CD_PROD, @CD_FILIAL


WHILE @@FETCH_STATUS = 0
BEGIN

	BEGIN TRY
		BEGIN TRAN

		SET @CD_PED = COALESCE((SELECT MAX(CD_PED) FROM EST_PED_VD WHERE CD_EMP = 1 AND CD_FILIAL = @CD_FILIAL), 0) + 1

		PRINT 'ROBO: ' + CONVERT(VARCHAR, @CD_EST_PROD_CPL_ROBO) + ' - FILIAL: ' + CONVERT(VARCHAR, @CD_FILIAL) + ' - PEDIDO: ' + CONVERT(VARCHAR, @CD_PED)

		INSERT INTO
			EST_PED_VD (
				CD_EMP
				,CD_FILIAL
				,CD_PED
				,CD_CLI
				,CD_VEND
				,CD_NT_MOV
				,DT_EMI_PED
				,VLR_TOT_PED
				,CD_COND_PGTO
				,NM_COMPRADOR
				,NM_TRANSP
				,FRETE
				,OBS
				,CD_USU
				,STS_PED
				,DT_FAT
				,VLR_TOT_PROD
				,VLR_DESC
				,DT_VALID
				,DT_CAD
				,DT_ULT_ATU
				,DT_BX
				,TP_BX
				,HORA_CAD
				,TP_PED
				,VLR_FRETE
				,OBS_NF1
				,OBS_NF2
				,PRZ_ENTRG
				,PRZ_VLD
				,COB
				,QT_VOL
				,DT_GRAVACAO
				,BLOQ_FATURAMENTO
				,VLR_ICMS_SUBS
				,VLR_ICMS_RETIDO
				,VLR_OUTROS_IT
				,FLAG_VALID_TRIB
				,XML_PEDIDO
				,FLAG_REALIZAR_FAT
				,DT_NF_SAIDA
				,FLAG_NAO_CALCULAR_IMPOSTO
				,VLR_BASE_ICMS
				,VLR_ICMS
				,VLR_BASE_ICMS_ST
				,VLR_IPI
				,ESP_VOL
				,MC_VOL
				,NR_VOL
				,PESO_VOL
				,PESO_LIQ_VOL
				,OBS_NF4
				,OBS_NF5
				,OBS_NF6
				,OBS_NF7
				,OBS_NF8
				,OBS_NF9
				,OBS_NF10
				,OBS_NF11
				,VLR_RESSARCIMENTO_BASE_SUBST
				,VLR_RESSARCIMENTO_ICMS_SUBST
				,VLR_ADJ_BASE_ICMS
				,VLR_ADJ_ICMS
				,CD_TRANSP
				,PLACA_VEIC
				,PLACA_UF
				,CGC_CPF_TRANSP
				,ENDE_TRANSP
				,DS_CID_TRANSP
				,UF_TRANSP
				,INSC_EST_TRANSP
				,EMAIL_TRANSP
				,DT_TRANSACAO
				,CD_CTR_DEVO
				,FLAG_GRAVA_PENDENCIA
				,NR_PROTOCOLO
				,FLAG_ECOMERCE
				,VERSAO_APLICATIVO
				,APLICATIVO
				,FLAG_FRETE_BASE_ICMS
				,TIPO_TRANSACAO
				,NR_END_DESTINATARIO
				,PONTO_REF_DESTINATARIO
				,END_DESTINATARIO
				,BAIRRO_DESTINATARIO
				,UF_DESTINATARIO
				,CEP_DESTINATARIO
				,CD_CID_DESTINATARIO
				,CIDADE_DESTINATARIO
				,VLR_FECOP_ST
				,FLAG_PRIORIDADE
				,VLR_FECOP
				,VLR_FECOP_RET
				,XPED_PEDIDO
				,FLAG_NAO_ABATER_ICMS_DESONERADO
				,NM_FRM
				,XPED_NOTA_FISCAL
				,FLAG_VLR_ICMS_DESONERADO_DESCONTO
				,CD_CID_TRANSP
				,BAIRRO_TRANSP
				,VLR_SUBSIDIO_MARKETPLACE)
		SELECT
			CD_EMP
			,@CD_FILIAL
			,@CD_PED
			,CD_FILIAL
			,1 AS CD_VEND
			,@CD_MOV_OP AS CD_NT_MOV
			,CONVERT(DATE, GETDATE()) AS DT_EMI_PED
			,DBO.F_VLR_CUSTO_EST_FECHA_PROC_MOV(1, @CD_FILIAL, CD_PROD, CONVERT(DATE, GETDATE()),  @TP_PRECO) * QTDE_PROD AS VLR_TOT_PED
			,1 AS CD_COND_PGTO
			,'' AS NM_COMPRADOR
			,'' AS NM_TRANSP
			,0 AS FRETE
			,'TRANSFERENCIA AUTOMATICA ROBO - CODIGO: ' + CONVERT(VARCHAR, CD_EST_PROD_CPL_ROBO) AS OBS
			,1 AS CD_USU
			,0 AS STS_PED
			,CONVERT(DATE, GETDATE()) AS DT_FAT
			,DBO.F_VLR_CUSTO_EST_FECHA_PROC_MOV(1, @CD_FILIAL, CD_PROD, CONVERT(DATE, GETDATE()),  @TP_PRECO) * QTDE_PROD AS VLR_TOT_PROD
			,0 AS VLR_DESC
			,DATEADD(DAY, 3, CONVERT(DATE, GETDATE())) AS DT_VALID
			,GETDATE() AS DT_CAD
			,NULL AS DT_ULT_ATU
			,NULL AS DT_BX
			,0 AS TP_BX
			,GETDATE() AS HORA_CAD
			,4 AS TP_PED
			,0 AS VLR_FRETE
			,'' AS OBS_NF1
			,'' AS OBS_NF2
			,0 AS PRZ_ENTRG
			,0 AS PRZ_VLD
			,0 AS COB
			,0 AS QT_VOL
			,GETDATE() AS DT_GRAVACAO
			,0 AS BLOQ_FATURAMENTO
			,0 AS VLR_ICMS_SUBS
			,0 AS VLR_ICMS_RETIDO
			,0 AS VLR_OUTROS_IT
			,0 AS FLAG_VALID_TRIB
			,NULL AS XML_PEDIDO
			,1 AS FLAG_REALIZAR_FAT
			,CONVERT(DATE, GETDATE()) AS DT_NF_SAIDA
			,0 AS FLAG_NAO_CALCULAR_IMPOSTO
			,0 AS VLR_BASE_ICMS
			,0 AS VLR_ICMS
			,0 AS VLR_BASE_ICMS_ST
			,0 AS VLR_IPI
			,'VOLUME' AS ESP_VOL
			,'DIVERSOS' AS MC_VOL
			,0 AS NR_VOL
			,0 AS PESO_VOL
			,0 AS PESO_LIQ_VOL
			,'' AS OBS_NF4	
			,'' AS OBS_NF5	
			,'' AS OBS_NF6	
			,'' AS OBS_NF7	
			,'' AS OBS_NF8	
			,'' AS OBS_NF9	
			,'' AS OBS_NF10
			,'' AS OBS_NF11
			,0 AS VLR_RESSARCIMENTO_BASE_SUBST
			,0 AS VLR_RESSARCIMENTO_ICMS_SUBST
			,0 AS VLR_ADJ_BASE_ICMS
			,0 AS VLR_ADJ_ICMS
			,0 AS CD_TRANSP
			,'' AS PLACA_VEIC
			,'' AS PLACA_UF
			,'' AS CGC_CPF_TRANSP
			,'' AS ENDE_TRANSP
			,'' AS DS_CID_TRANSP
			,'' AS UF_TRANSP
			,'' AS INSC_EST_TRANSP
			,'' AS EMAIL_TRANSP
			,GETDATE() AS DT_TRANSACAO
			,'' AS CD_CTR_DEVO
			,0 AS FLAG_GRAVA_PENDENCIA
			,NULL AS NR_PROTOCOLO
			,0 AS FLAG_ECOMERCE
			,'1.0' AS VERSAO_APLICATIVO
			,'PROC TRANSF ROBO' AS APLICATIVO
			,0 AS FLAG_FRETE_BASE_ICMS
			,NULL AS TIPO_TRANSACAO
			,'' AS NR_END_DESTINATARIO
			,'' AS PONTO_REF_DESTINATARIO
			,'' AS END_DESTINATARIO
			,'' AS BAIRRO_DESTINATARIO
			,'' AS UF_DESTINATARIO
			,'' AS CEP_DESTINATARIO
			,0 AS CD_CID_DESTINATARIO
			,'' AS CIDADE_DESTINATARIO
			,0 AS VLR_FECOP_ST
			,0 AS FLAG_PRIORIDADE
			,0 AS VLR_FECOP
			,0 AS VLR_FECOP_RET
			,'' AS XPED_PEDIDO
			,0 AS FLAG_NAO_ABATER_ICMS_DESONERADO
			,'P_GERA_EST_PROD_CPL_ROBO_TRANSF' AS NM_FRM
			,'' AS XPED_NOTA_FISCAL
			,0 AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
			,0 AS CD_CID_TRANSP
			,'' AS BAIRRO_TRANSP
			,0 AS VLR_SUBSIDIO_MARKETPLACE
		FROM
			EST_PROD_CPL_ROBO
		WHERE
			CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO
			
		INSERT INTO
			EST_PED_VD_IT (
				CD_EMP
				,CD_FILIAL
				,CD_PED
				,CD_PROD
				,QT_IT
				,VLR_IT
				,VLR_DESC
				,QT_EST_ANT
				,PERC_IPI
				,PERC_DESC
				,VLR_ICMS_SUBS_FUT
				,VLR_PROD_PED
				,VLR_SUFRAMA
				,ORD_GRAVA
				,PERC_DESC_CTR
				,PERC_COMI
				,PERC_COMI_CTR
				,VALIDADE
				,CD_TRIB
				,VLR_PMC
				,VLR_ICMS_SUBS
				,VLR_ICMS_RETIDO
				,VLR_IMPOSTO_REA
				,VLR_OUTROS_IT
				,VLR_BASE_ICMS_SUBS
				,VLR_BASE_ICMS_IT
				,VLR_TOT_IT
				,VLR_ISENTO
				,VLR_OUTROS
				,PERC_REDU_BASE_SUBS
				,PERC_REDU_BASE_ICMS
				,VLR_PROD_FRETE
				,VLR_BASE_PIS
				,VLR_PIS
				,PERC_ALIQ_PIS
				,VLR_BASE_COFINS
				,VLR_COFINS
				,PERC_ALIQ_COFINS
				,VLR_BASE_ICMS_RET
				,VLR_OUTROS_DESPESAS
				,ALIQ_ICMS
				,VLR_ICMS_IT
				,VLR_CUSTO
				,ALIQ_ICMS_INTERNO
				,PERC_IVA
				,VLR_CUSTO_MD
				,CD_TRIB_SIMPLES
				,VLR_CUSTO_ACERTO
				,VLR_ICMS_DESONERADO
				,ICMS_DESONERADO_MOTIVO
				,PERC_ICMS_DESTINO_DIFAL
				,PERC_ICMS_ORIGEM_DIFAL
				,GERAR_DIFAL
				,VLR_BASE_ICMS_OP
				,VLR_ICMS_OP
				,PERC_ICMS_OP
				,PERC_DIFERIMENTO
				,VLR_ICMS_DIFERIMENTO
				,CD_NF_REF
				,PERC_ICMS_LUCRO_REAL
				,VLR_ICMS_LUCRO_REAL
				,VLR_BASE_ICMS_LUCRO_REAL
				,VLR_CRED_ICMS_SN
				,VLR_CRED_BASE_SN
				,PERC_DESC_FINAN
				,VLR_DESC_FINAN
				,QT_SOL
				,ALIQ_ICMS_ENTRADA
				,VLR_BASE_FECOP
				,PERC_FECOP
				,VLR_FECOP
				,VLR_BASE_FECOP_RET
				,VLR_FECOP_RET
				,PERC_FECOP_RET
				,VLR_FECOP_ST
				,VLR_BASE_FECOP_ST
				,PERC_FECOP_ST
				,PERC_ICMS_RET
				,MODALI_BASE_ICMS_SUBST
				,MODALI_BASE_ICMS
				,VLR_CUSTO_PROD_ORIG
				,CD_BENEF
				,XPED_IT
				,CD_NT_OP
				,CD_SIT_OPERA_SIMPLES_NACIO
				,OBSERVACOES_FISCAIS_CONTRIBUINTE)
		SELECT
			CD_EMP
			,@CD_FILIAL
			,@CD_PED
			,CD_PROD
			,QTDE_PROD AS QT_IT
			,DBO.F_VLR_CUSTO_EST_FECHA_PROC_MOV(1, @CD_FILIAL, CD_PROD, CONVERT(DATE, GETDATE()),  @TP_PRECO) AS VLR_IT
			,0 AS VLR_DESC
			,0 AS QT_EST_ANT
			,0 AS PERC_IPI
			,0 AS PERC_DESC
			,0 AS VLR_ICMS_SUBS_FUT
			,0 AS VLR_PROD_PED
			,0 AS VLR_SUFRAMA
			,1 AS ORD_GRAVA
			,0 AS PERC_DESC_CTR
			,0 AS PERC_COMI
			,0 AS PERC_COMI_CTR
			,0 AS VALIDADE
			,0 AS CD_TRIB
			,0 AS VLR_PMC
			,0 AS VLR_ICMS_SUBS
			,0 AS VLR_ICMS_RETIDO
			,0 AS VLR_IMPOSTO_REA
			,0 AS VLR_OUTROS_IT
			,0 AS VLR_BASE_ICMS_SUBS
			,0 AS VLR_BASE_ICMS_IT
			,DBO.F_VLR_CUSTO_EST_FECHA_PROC_MOV(1, @CD_FILIAL, CD_PROD, CONVERT(DATE, GETDATE()),  @TP_PRECO) * QTDE_PROD AS VLR_TOT_IT
			,0 AS VLR_ISENTO
			,0 AS VLR_OUTROS
			,0 AS PERC_REDU_BASE_SUBS
			,0 AS PERC_REDU_BASE_ICMS
			,0 AS VLR_PROD_FRETE	
			,0 AS VLR_BASE_PIS
			,0 AS VLR_PIS
			,0 AS PERC_ALIQ_PIS
			,0 AS VLR_BASE_COFINS
			,0 AS VLR_COFINS
			,0 AS PERC_ALIQ_COFINS
			,0 AS VLR_BASE_ICMS_RET
			,0 AS VLR_OUTROS_DESPESAS
			,0 AS ALIQ_ICMS
			,0 AS VLR_ICMS_IT
			,0 AS VLR_CUSTO
			,0 AS ALIQ_ICMS_INTERNO
			,0 AS PERC_IVA
			,0 AS VLR_CUSTO_MD
			,0 AS CD_TRIB_SIMPLES
			,0 AS VLR_CUSTO_ACERTO
			,0 AS VLR_ICMS_DESONERADO
			,0 AS ICMS_DESONERADO_MOTIVO
			,0 AS PERC_ICMS_DESTINO_DIFAL
			,0 AS PERC_ICMS_ORIGEM_DIFAL
			,0 AS GERAR_DIFAL
			,0 AS VLR_BASE_ICMS_OP
			,0 AS VLR_ICMS_OP
			,0 AS PERC_ICMS_OP
			,0 AS PERC_DIFERIMENTO
			,0 AS VLR_ICMS_DIFERIMENTO
			,NULL AS CD_NF_REF
			,0 AS PERC_ICMS_LUCRO_REAL
			,0 AS VLR_ICMS_LUCRO_REAL
			,0 AS VLR_BASE_ICMS_LUCRO_REAL
			,0 AS VLR_CRED_ICMS_SN
			,0 AS VLR_CRED_BASE_SN
			,0 AS PERC_DESC_FINAN
			,0 AS VLR_DESC_FINAN
			,0 AS QT_SOL
			,0 AS ALIQ_ICMS_ENTRADA
			,0 AS VLR_BASE_FECOP
			,0 AS PERC_FECOP
			,0 AS VLR_FECOP
			,0 AS VLR_BASE_FECOP_RET
			,0 AS VLR_FECOP_RET
			,0 AS PERC_FECOP_RET
			,0 AS VLR_FECOP_ST
			,0 AS VLR_BASE_FECOP_ST
			,0 AS PERC_FECOP_ST
			,0 AS PERC_ICMS_RET
			,NULL AS MODALI_BASE_ICMS_SUBST
			,NULL AS MODALI_BASE_ICMS
			,0 AS VLR_CUSTO_PROD_ORIG
			,NULL AS CD_BENEF
			,0 AS XPED_IT
			,NULL AS CD_NT_OP
			,0 AS CD_SIT_OPERA_SIMPLES_NACIO
			,NULL OBSERVACOES_FISCAIS_CONTRIBUINTE
		FROM
			EST_PROD_CPL_ROBO
		WHERE
			CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO

		INSERT INTO
			EST_PED_VD_EST_PROD_CPL_ROBO (
				CD_EMP
				,CD_FILIAL
				,CD_PED
				,CD_EST_PROD_CPL_ROBO)
		SELECT
			CD_EMP
			,@CD_FILIAL
			,@CD_PED
			,CD_EST_PROD_CPL_ROBO
		FROM
			EST_PROD_CPL_ROBO
		WHERE
			CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO


		BEGIN TRY
			SELECT
				@XML = CONVERT(XML, OBS)
			FROM
				EST_PROD_CPL_ROBO
			WHERE
				CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO


			SELECT
				@NR_LOTE = @XML.value('(/WWKS/OutputMessage/Article/Pack)[1]/@BatchNumber','varchar(max)'),
				@DT_VALID = CONVERT(DATE, @XML.value('(/WWKS/OutputMessage/Article/Pack)[1]/@ExpiryDate','varchar(max)')),
				@DT_FABRIC = CONVERT(DATE, @XML.value('(/WWKS/OutputMessage/Article/Pack)[1]/@StockInDate','varchar(max)'))



			SET @CD_LOTE = COALESCE((SELECT CD_LOTE FROM EST_PROD_CPL_LOTE WHERE CD_EMP = 1 AND CD_FILIAL = @CD_FILIAL AND CD_PROD = @CD_PROD AND NR_LOTE = @NR_LOTE), -1)

			IF @CD_LOTE = -1
			BEGIN

				SET @CD_LOTE = COALESCE((SELECT MAX(CD_LOTE) FROM EST_PROD_CPL_LOTE WHERE CD_EMP = 1 AND CD_FILIAL = @CD_FILIAL), 0) + 1
				
				INSERT INTO
					EST_PROD_CPL_LOTE (
						CD_EMP
						,CD_FILIAL
						,CD_LOTE
						,CD_PROD
						,NR_LOTE
						,DT_VALID
						,QTDE_PROD
						,DT_FABRIC
						,DT_FABR
						,DT_CAD
						,CD_AGREGADOR
						,CD_USU_ALT
						,DT_ALT
						,CD_USU)
				SELECT
					CD_EMP
					,@CD_FILIAL
					,@CD_LOTE
					,@CD_PROD
					,@NR_LOTE
					,@DT_VALID
					,QTDE_PROD
					,0 AS DT_FABRIC
					,@DT_FABRIC
					,GETDATE() AS DT_CAD
					,'' AS CD_AGREGADOR
					,NULL AS CD_USU_ALT
					,NULL AS DT_ALT
					,1 AS CD_USU
				FROM
					EST_PROD_CPL_ROBO
				WHERE
					CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO
			END

			INSERT INTO
				EST_PED_VD_IT_EST_PROD_CPL_LOTE (
					CD_EMP
					,CD_FILIAL
					,CD_PED
					,CD_PROD
					,CD_LOTE
					,QTDE_PROD
					,DT_CAD
					,CD_USU_ALT
					,DT_ALT
					,CD_USU)
			SELECT
				CD_EMP
				,@CD_FILIAL
				,@CD_PED
				,@CD_PROD
				,@CD_LOTE
				,QTDE_PROD
				,GETDATE() AS DT_CAD
				,NULL AS CD_USU_ALT
				,NULL AS DT_ALT
				,1 AS CD_USU
			FROM
				EST_PROD_CPL_ROBO
			WHERE
				CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO


		END TRY
		BEGIN CATCH
			PRINT 'LOTE NO ENCONTRADO PARA O CONTROLE ' + CONVERT(VARCHAR, @CD_EST_PROD_CPL_ROBO)
		END CATCH
			



		DELETE FROM EST_PROD_CPL_ROBO_PEND_TRANSF WHERE CD_EST_PROD_CPL_ROBO = @CD_EST_PROD_CPL_ROBO
			
		COMMIT
		FETCH NEXT FROM CURSOR_TRANSF INTO @CD_EST_PROD_CPL_ROBO, @CD_PROD, @CD_FILIAL

	END TRY
	 BEGIN CATCH
		ROLLBACK
        INSERT INTO ADM_ERRO
			(NUMERO
		   , SEVERIDADE
		   , ESTADO
		   , ROTINA
		   , LINHA
		   , MENSAGEM
		   , DTERRO
			)
        SELECT 
			ERROR_NUMBER() AS numero
            , ERROR_SEVERITY() AS severidade
            , ERROR_STATE() AS estado
            , ERROR_PROCEDURE() AS rotina
            , ERROR_LINE() AS linha
            , ERROR_MESSAGE() AS mensagem
            , GETDATE() AS dtErro;

		FETCH NEXT FROM CURSOR_TRANSF INTO @CD_EST_PROD_CPL_ROBO, @CD_FILIAL
    END CATCH;

	

END

CLOSE CURSOR_TRANSF
DEALLOCATE CURSOR_TRANSF



END